/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.extended;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.globus.gsi.gssapi.net.GssInputStream;
import org.globus.util.Base64;
import org.ietf.jgss.GSSContext;

public class GridFTPInputStream
extends GssInputStream {
    public GridFTPInputStream(InputStream in, GSSContext context) {
        super(new BufferedInputStream(in), context);
    }

    private String readLine() throws IOException {
        int c = this.in.read();
        if (c == -1) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append((char)c);
        while ((c = this.in.read()) != -1) {
            if (c == 13) {
                c = this.in.read();
                if (c == 10 || c == -1) break;
                throw new IOException("bad format");
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    public byte[] readHandshakeToken() throws IOException {
        String line = this.readLine();
        if (line == null) {
            throw new EOFException();
        }
        if (line.startsWith("335 ADAT=") || line.startsWith("334 ADAT=")) {
            return Base64.decode(line.substring(9).getBytes());
        }
        if (line.startsWith("335 more data needed")) {
            return new byte[0];
        }
        throw new IOException(this.handleReply(line));
    }

    private String handleReply(String line) throws IOException {
        if ((line = line.trim()).length() > 4 && line.charAt(3) == '-') {
            String lineSeparator = System.getProperty("line.separator");
            String lastLineStarts = line.substring(0, 3) + ' ';
            StringBuffer buf = new StringBuffer();
            buf.append(line);
            do {
                if ((line = this.readLine()) == null) {
                    throw new EOFException();
                }
                line = line.trim();
                buf.append(lineSeparator).append(line);
            } while (!line.startsWith(lastLineStarts));
            return buf.toString();
        }
        return line;
    }

    protected void readMsg() throws IOException {
        String line = this.readLine();
        if (line == null) {
            throw new EOFException();
        }
        if (line.charAt(0) == '6') {
            this.buff = this.unwrap(Base64.decode(line.substring(4).getBytes()));
            this.index = 0;
            byte last = this.buff[this.buff.length - 1];
            if (last == 0) {
                if (this.buff[this.buff.length - 2] != 10) {
                    this.buff[this.buff.length - 1] = 10;
                }
            } else if (last != 10) {
                byte[] newBuff = new byte[this.buff.length + 1];
                System.arraycopy(this.buff, 0, newBuff, 0, this.buff.length);
                newBuff[this.buff.length] = 10;
                this.buff = newBuff;
            }
        } else {
            throw new IOException(line);
        }
    }
}

