/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.proxy;

import javax.swing.JLabel;
import org.globus.common.CoGProperties;
import org.globus.tools.proxy.ProxyOptionsPanel;
import org.globus.tools.ui.util.FileBrowser;

public class DefaultProxyOptionsPanel
extends ProxyOptionsPanel {
    protected FileBrowser certFileFB;
    protected FileBrowser keyFileFB;

    public DefaultProxyOptionsPanel() {
        this.setAnchor(13);
        this.gbc.weightx = 0.0;
        this.setFill(0);
        this.add(new JLabel("User Certificate: "), 0, 4, 1, 1);
        this.add(new JLabel("User Private Key: "), 0, 5, 1, 1);
        this.setAnchor(17);
        this.gbc.weightx = 1.0;
        this.setFill(2);
        this.certFileFB = new FileBrowser("Select User Certificate", "Select");
        this.add(this.certFileFB, 1, 4, 1, 1);
        this.keyFileFB = new FileBrowser("Select User Private Key", "Select");
        this.add(this.keyFileFB, 1, 5, 1, 1);
    }

    public boolean validateSettings() {
        if (!super.validateSettings()) {
            return false;
        }
        if (this.certFileFB.getFile().equals("")) {
            return this.error("Please enter the certificate file location");
        }
        if (this.keyFileFB.getFile().equals("")) {
            return this.error("Please enter the private key file location");
        }
        return true;
    }

    public void set(CoGProperties props) {
        super.set(props);
        this.certFileFB.setFile(props.getUserCertFile());
        this.keyFileFB.setFile(props.getUserKeyFile());
    }

    public void get(CoGProperties props) {
        super.get(props);
        props.setUserCertFile(this.certFileFB.getFile());
        props.setUserKeyFile(this.keyFileFB.getFile());
    }
}

