/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.common;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.globus.gsi.gssapi.GlobusGSSContextImpl;
import org.globus.security.gridmap.GridMap;

public class GridMapAuthHandler
extends BasicHandler {
    private String gridmapLoc = null;
    private static Logger logger = Logger.getLogger((String)GridMapAuthHandler.class.getName());

    public void init() {
        super.init();
        this.gridmapLoc = (String)this.getOption("gridmap");
        if (this.gridmapLoc == null) {
            this.gridmapLoc = "/etc/grid-security/grid-mapfile";
        }
        logger.info((Object)("Location of gridmap: " + this.gridmapLoc));
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        logger.info((Object)"entering");
        Object tmp = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (tmp == null || !(tmp instanceof HttpServletRequest)) {
            logger.info((Object)"exiting");
            return;
        }
        HttpServletRequest req = (HttpServletRequest)tmp;
        Object userDN = req.getAttribute("org.globus.gsi.authorized.user.dn");
        if (userDN == null) {
            logger.info((Object)"exiting");
            return;
        }
        logger.info((Object)("Client's DN: " + userDN));
        Object gssContext = req.getAttribute("org.globus.gsi.context");
        try {
            if (gssContext != null) {
                logger.debug((Object)("Source name: " + ((GlobusGSSContextImpl)gssContext).getSrcName()));
                logger.debug((Object)("Target name: " + ((GlobusGSSContextImpl)gssContext).getTargName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        GridMap gridmap = new GridMap();
        try {
            gridmap.load(this.gridmapLoc);
        }
        catch (IOException ioe) {
            logger.fatal((Object)"Can't load gridmap", (Throwable)ioe);
            throw new AxisFault("Can't load gridmap", (Throwable)ioe);
        }
        if (gridmap.getUserID((String)userDN) == null) {
            logger.info((Object)"User not on the gridmap");
            throw new AxisFault("User: " + userDN + " does not have an entry on the gridmap");
        }
        logger.info((Object)"exiting");
    }
}

