/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal;

import edu.sdsc.nbcr.opal.AppMetadataInputType;
import edu.sdsc.nbcr.opal.AppMetadataType;
import edu.sdsc.nbcr.opal.AppServiceLocator;
import edu.sdsc.nbcr.opal.AppServicePortType;
import edu.sdsc.nbcr.opal.InputFileType;
import edu.sdsc.nbcr.opal.JobInputType;
import edu.sdsc.nbcr.opal.JobOutputType;
import edu.sdsc.nbcr.opal.JobStatisticsType;
import edu.sdsc.nbcr.opal.JobSubOutputType;
import edu.sdsc.nbcr.opal.OutputFileType;
import edu.sdsc.nbcr.opal.StatusOutputType;
import edu.sdsc.nbcr.opal.SystemInfoInputType;
import edu.sdsc.nbcr.opal.SystemInfoType;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.rpc.Stub;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.types.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.globus.axis.transport.HTTPSSender;
import org.globus.axis.util.Util;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;

public class GenericServiceClient {
    public static void main(String[] args) throws Exception {
        StatusOutputType status;
        HelpFormatter formatter;
        String jobID;
        MessageContext mc;
        StringWriter sw;
        TypeDesc typeDesc;
        String proto;
        String serviceURL = null;
        String operation = null;
        Options options = new Options();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"service url");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withArgName((String)"operation");
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"remote operation to invoke: [getAppMetadata|launchJob|queryStatus|\ngetSystemInfo|getStatistics|getOutputs|destroy]");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withArgName((String)"num_procs");
        OptionBuilder.withDescription((String)"number of processors for parallel job");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withArgName((String)"job_id");
        OptionBuilder.withDescription((String)"job id for a run");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"j"));
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.withDescription((String)"command line arguments");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withArgName((String)"email");
        OptionBuilder.withDescription((String)"user email for notification and logging");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withArgName((String)"url1,url2,..");
        OptionBuilder.withDescription((String)"input file urls");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)-2);
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withArgName((String)"file1,file2,..");
        OptionBuilder.withDescription((String)"local input files as Base64 binary");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)-2);
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)"attch1,attch2,..");
        OptionBuilder.withDescription((String)"local input files as a binary attachment");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs((int)-2);
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withArgName((String)"extract");
        OptionBuilder.withDescription((String)"extract input files that are zipped");
        options.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withArgName((String)"notify");
        OptionBuilder.withDescription((String)"notify users by email when job is complete");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withArgName((String)"serverDN");
        OptionBuilder.withDescription((String)"server DN expected - if gsi is being used");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"dn"));
        System.out.println("\nReading command line arguments");
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (Exception e) {
            HelpFormatter formatter2 = new HelpFormatter();
            formatter2.printHelp("java edu.sdsc.nbcr.opal.GenericServiceClient", options);
            System.exit(1);
        }
        serviceURL = line.getOptionValue("l");
        System.out.println("Service URL: " + serviceURL);
        operation = line.getOptionValue("r");
        System.out.println("Invoking operation: " + operation);
        String serverDN = "/C=US/O=nbcr/OU=sdsc/CN=apbs_service";
        if (line.getOptionValue("dn") != null) {
            serverDN = line.getOptionValue("dn");
            System.out.println("Server DN: " + serverDN);
        }
        System.out.print("\n");
        AppServiceLocator asl = new AppServiceLocator();
        int index = serviceURL.indexOf(":");
        boolean httpsInUse = false;
        if (index > 0 && (proto = serviceURL.substring(0, index)).equals("https")) {
            httpsInUse = true;
        }
        if (httpsInUse) {
            SimpleProvider provider = new SimpleProvider();
            SimpleTargetedChain c = new SimpleTargetedChain((Handler)new HTTPSSender());
            provider.deployTransport("https", (Handler)c);
            asl.setEngine((AxisEngine)new AxisClient((EngineConfiguration)provider));
            Util.registerTransport();
            System.out.println("HTTPS protocol handler registered\n");
        }
        AppServicePortType appServicePort = asl.getAppServicePort(new URL(serviceURL));
        GSSCredential proxy = null;
        if (httpsInUse) {
            String proxyPath = System.getProperty("X509_USER_PROXY");
            if (proxyPath == null) {
                System.err.println("Required property X509_USER_PROXY not set");
                System.exit(1);
            }
            File f = new File(proxyPath);
            byte[] data = new byte[(int)f.length()];
            FileInputStream in = new FileInputStream(f);
            in.read(data);
            in.close();
            ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
            proxy = manager.createCredential(data, 0, 0, null, 0);
        }
        IdentityAuthorization auth = new IdentityAuthorization(serverDN);
        if (httpsInUse) {
            ((Stub)appServicePort)._setProperty("org.globus.gsi.authorization", (Object)auth);
            ((Stub)appServicePort)._setProperty("org.globus.gsi.credentials", proxy);
        }
        if (operation.equals("getAppMetadata")) {
            System.out.println("Getting application metadata - ");
            AppMetadataType amt = appServicePort.getAppMetadata(new AppMetadataInputType());
            typeDesc = amt.getTypeDesc();
            sw = new StringWriter();
            mc = new MessageContext((AxisEngine)new AxisClient());
            SerializationContext sc = new SerializationContext((Writer)sw, mc);
            sc.setDoMultiRefs(false);
            sc.setPretty(true);
            sc.serialize(typeDesc.getXmlType(), null, (Object)amt, typeDesc.getXmlType(), new Boolean(true), new Boolean(true));
            sw.close();
            System.out.println(sw.toString());
        } else if (operation.equals("getSystemInfo")) {
            System.out.println("Getting system information- ");
            SystemInfoType sit = appServicePort.getSystemInfo(new SystemInfoInputType());
            typeDesc = sit.getTypeDesc();
            sw = new StringWriter();
            mc = new MessageContext((AxisEngine)new AxisClient());
            SerializationContext sc = new SerializationContext((Writer)sw, mc);
            sc.setDoMultiRefs(false);
            sc.setPretty(true);
            sc.serialize(typeDesc.getXmlType(), null, (Object)sit, typeDesc.getXmlType(), new Boolean(true), new Boolean(true));
            sw.close();
            System.out.println(sw.toString());
        } else if (operation.equals("launchJob")) {
            int arraySize;
            String[] attachFiles;
            String[] inputURLs;
            InputFileType infile;
            String email;
            boolean extractInputs;
            String numProcs;
            JobInputType in = new JobInputType();
            String cmdArgs = line.getOptionValue("a");
            if (cmdArgs != null) {
                System.out.println("Command line arguments: " + cmdArgs);
                in.setArgList(cmdArgs);
            }
            if ((numProcs = line.getOptionValue("n")) != null) {
                System.out.println("Number of processors: " + numProcs);
                in.setNumProcs(new Integer(numProcs));
            }
            if (extractInputs = line.hasOption("z")) {
                System.out.println("Instructing server to unzip/untar zipped files");
                in.setExtractInputs(true);
            }
            if ((email = line.getOptionValue("e")) != null) {
                System.out.println("User email for notification: " + email);
                in.setUserEmail(email);
                boolean notifyUsers = line.hasOption("m");
                if (notifyUsers) {
                    System.out.println("Instructing server to notify on job completion");
                    in.setSendNotification(notifyUsers);
                }
            }
            Vector<InputFileType> inputFileVector = new Vector<InputFileType>();
            String[] inputFiles = line.getOptionValues("f");
            if (inputFiles != null) {
                for (int i = 0; i < inputFiles.length; ++i) {
                    File f = new File(inputFiles[i]);
                    byte[] data = new byte[(int)f.length()];
                    FileInputStream fIn = new FileInputStream(f);
                    fIn.read(data);
                    fIn.close();
                    infile = new InputFileType();
                    infile.setName(f.getName());
                    infile.setContents(data);
                    inputFileVector.add(infile);
                }
            }
            if ((inputURLs = line.getOptionValues("u")) != null) {
                for (int i = 0; i < inputURLs.length; ++i) {
                    String address = inputURLs[i];
                    int lastSlashIndex = address.lastIndexOf(47);
                    String fileName = null;
                    if (lastSlashIndex >= 0 && lastSlashIndex < address.length() - 1) {
                        fileName = address.substring(lastSlashIndex + 1);
                    } else {
                        System.err.println("Could not figure out local file name for " + address);
                        System.exit(1);
                    }
                    InputFileType infile2 = new InputFileType();
                    infile2.setName(fileName);
                    infile2.setLocation(new URI(address));
                    inputFileVector.add(infile2);
                }
            }
            if ((attachFiles = line.getOptionValues("b")) != null) {
                for (int i = 0; i < attachFiles.length; ++i) {
                    DataHandler dh = new DataHandler((DataSource)new FileDataSource(attachFiles[i]));
                    infile = new InputFileType();
                    File f = new File(attachFiles[i]);
                    infile.setName(f.getName());
                    infile.setAttachment(dh);
                    inputFileVector.add(infile);
                }
            }
            if ((arraySize = inputFileVector.size()) > 0) {
                InputFileType[] infileArray = new InputFileType[arraySize];
                for (int i = 0; i < arraySize; ++i) {
                    infileArray[i] = (InputFileType)inputFileVector.get(i);
                }
                in.setInputFile(infileArray);
            }
            System.out.println("Making non-blocking invocation on Opal service -");
            JobSubOutputType subOut = appServicePort.launchJob(in);
            System.out.println("Received jobID: " + subOut.getJobID());
            StatusOutputType status2 = subOut.getStatus();
            System.out.println("Current Status:\n\tCode: " + status2.getCode() + "\n" + "\tMessage: " + status2.getMessage() + "\n" + "\tOutput Base URL: " + status2.getBaseURL());
        } else if (operation.equals("queryStatus")) {
            jobID = line.getOptionValue("j");
            if (jobID == null) {
                System.err.println("Required option -j not found for queryStatus operation");
                formatter = new HelpFormatter();
                formatter.printHelp("java edu.sdsc.nbcr.opal.GenericServiceClient", options);
                System.exit(1);
            }
            System.out.println("Retrieving job status");
            status = appServicePort.queryStatus(jobID);
            System.out.println("Status for job: " + jobID + "\n" + "\tCode: " + status.getCode() + "\n" + "\tMessage: " + status.getMessage() + "\n" + "\tOutput Base URL: " + status.getBaseURL());
        } else if (operation.equals("getStatistics")) {
            jobID = line.getOptionValue("j");
            if (jobID == null) {
                System.err.println("Required option -j not found for getStatistics operation");
                formatter = new HelpFormatter();
                formatter.printHelp("java edu.sdsc.nbcr.opal.GenericServiceClient", options);
                System.exit(1);
            }
            System.out.println("Retrieving job statistics");
            JobStatisticsType stats = appServicePort.getJobStatistics(jobID);
            System.out.println("Statistics for job: " + jobID + "\n" + "\tSubmission time: " + stats.getStartTime().getTime());
            if (stats.getActivationTime() != null) {
                System.out.println("\tActivation time: " + stats.getActivationTime().getTime());
            }
            if (stats.getCompletionTime() != null) {
                System.out.println("\tCompletion time: " + stats.getCompletionTime().getTime());
            }
        } else if (operation.equals("getOutputs")) {
            jobID = line.getOptionValue("j");
            if (jobID == null) {
                System.err.println("Required option -j not found for queryStatus operation");
                formatter = new HelpFormatter();
                formatter.printHelp("java edu.sdsc.nbcr.opal.GenericServiceClient", options);
                System.exit(1);
            }
            System.out.println("Retrieving job output -");
            JobOutputType out = appServicePort.getOutputs(jobID);
            System.out.println("Standard output: " + out.getStdOut().toString());
            System.out.println("Standard error: " + out.getStdErr().toString());
            OutputFileType[] outfile = out.getOutputFile();
            if (outfile != null) {
                for (int i = 0; i < outfile.length; ++i) {
                    System.out.println(outfile[i].getName() + ": " + outfile[i].getUrl());
                }
            }
        } else if (operation.equals("destroy")) {
            jobID = line.getOptionValue("j");
            System.out.println("Job id: " + jobID);
            if (jobID == null) {
                System.err.println("Required option -j not found for queryStatus operation");
                formatter = new HelpFormatter();
                formatter.printHelp("java edu.sdsc.nbcr.opal.GenericServiceClient", options);
                System.exit(1);
            }
            System.out.println("Destroying job");
            status = appServicePort.destroy(jobID);
            System.out.println("Final status for job: " + jobID + "\n" + "\tCode: " + status.getCode() + "\n" + "\tMessage: " + status.getMessage() + "\n" + "\tOutput Base URL: " + status.getBaseURL());
        } else {
            System.err.println("Operation " + operation + " not supported");
            System.exit(1);
        }
    }
}

