/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.manager;

import edu.sdsc.nbcr.opal.manager.JobManagerException;
import edu.sdsc.nbcr.opal.manager.OpalJobManager;
import org.apache.log4j.Logger;

public class OpalJobManagerFactory {
    private static Logger logger = Logger.getLogger((String)OpalJobManagerFactory.class.getName());

    public static OpalJobManager getOpalJobManager(String jobManagerFQCN) throws JobManagerException {
        if (jobManagerFQCN == null) {
            throw new JobManagerException("Classname for job manager is null");
        }
        Class<?> managerClass = null;
        try {
            managerClass = Class.forName(jobManagerFQCN);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Can't instantiate Opal Job Manager - Job manager class " + jobManagerFQCN + " not found";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        if (!OpalJobManager.class.isAssignableFrom(managerClass)) {
            String msg = "Can't instantiate Opal Job Manager - " + jobManagerFQCN + " does not implement the OpalJobManager interface";
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        Object managerObject = null;
        try {
            managerObject = managerClass.newInstance();
        }
        catch (Exception e) {
            String msg = "Opal Job manager object can't be instantiated from class: " + jobManagerFQCN;
            logger.error((Object)msg);
            throw new JobManagerException(msg);
        }
        return managerObject;
    }
}

