/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.nbcr.opal.util;

import edu.sdsc.nbcr.common.TypeDeserializer;
import edu.sdsc.nbcr.opal.AppConfigType;
import edu.sdsc.nbcr.opal.ArgumentsType;
import edu.sdsc.nbcr.opal.FaultType;
import edu.sdsc.nbcr.opal.util.ArgValidator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class PackageTest
extends TestCase {
    private static Logger logger = Logger.getLogger((String)PackageTest.class.getName());

    public static void main(String[] args) {
        TestRunner.run((Test)PackageTest.suite());
        System.exit(0);
    }

    public PackageTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PackageTest.class);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testArgValidator() {
        String msg;
        boolean success;
        String configFile = "configs/pdb2pqr_config.xml";
        String workingDir = "samples";
        System.out.println("Reading application configuration from file");
        AppConfigType appConfig = null;
        try {
            appConfig = (AppConfigType)TypeDeserializer.getValue(configFile, new AppConfigType());
            PackageTest.assertNotNull((String)"Can't create appConfig from configuration file", (Object)appConfig);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            PackageTest.fail((String)"Can't create appConfig from configuration file");
            return;
        }
        ArgumentsType argsDesc = appConfig.getMetadata().getTypes();
        if (argsDesc == null) {
            PackageTest.fail((String)("Opal configuration file: " + configFile + " does not include argument description"));
            return;
        }
        ArgValidator av = new ArgValidator(argsDesc);
        System.out.println("Validating correctness of arguments");
        String cmdArgs = "--noopt --verbose --ff=AMBER sample.pdb output.pqr";
        try {
            success = av.validateArgList(workingDir, cmdArgs);
            if (success) {
                System.out.println("Argument validation successful");
            } else {
                msg = "Argument validation unsuccessful";
                System.err.println(msg);
                PackageTest.fail((String)msg);
            }
        }
        catch (FaultType f) {
            logger.error((Object)f.getMessage1());
            PackageTest.fail((String)("Argument validation unsuccessful: " + f.getMessage1()));
        }
        System.out.println("Validating incorrectness of arguments");
        cmdArgs = "--foo --verbose --ff=AMBER sample.pdb output.pqr";
        try {
            success = av.validateArgList(workingDir, cmdArgs);
            PackageTest.fail((String)"Argument validation incorrectly returned successfully");
        }
        catch (FaultType f) {
            msg = f.getMessage1();
            System.out.println("Argument validation unsuccessful as expected: " + msg);
        }
    }
}

