/*
 * Decompiled with CFR 0.152.
 */
package org.inria.genouest.opal.tools.soaprequest.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.inria.genouest.opal.tools.soaprequest.filter.OpalSOAPRequestWrapper;

public class OpalSOAPRequestFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private static final Logger logger = Logger.getLogger(OpalSOAPRequestFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String path = req.getRequestURL().toString();
        String[] servletPathSplit = path.split("/");
        if (servletPathSplit.length >= 2 && servletPathSplit[servletPathSplit.length - 2].equals("services") && !servletPathSplit[servletPathSplit.length - 1].equals("AxisServlet") && !servletPathSplit[servletPathSplit.length - 1].equals("AdminService") && !servletPathSplit[servletPathSplit.length - 1].equals("Version")) {
            OpalSOAPRequestWrapper reqWrapper = new OpalSOAPRequestWrapper(req, this.filterConfig.getServletContext(), servletPathSplit[servletPathSplit.length - 1]);
            chain.doFilter((ServletRequest)reqWrapper, response);
        } else {
            logger.debug((Object)"Incoming request is not a typed SOAP request");
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try {
            BufferedReader input = new BufferedReader(new FileReader(aFile));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return contents.toString();
    }
}

