package au.edu.uq.imb.memesuite.db;

import au.edu.uq.imb.memesuite.data.Alph;
import au.edu.uq.imb.memesuite.data.AlphStd;
import au.edu.uq.imb.memesuite.data.SequenceInfo;
import au.edu.uq.imb.memesuite.util.JsonWr;

import java.io.IOException;

/**
 * Information about a sequence database with statistics on the contained sequences.
 */
public class SequenceDB implements SequenceInfo {
  private String listingName;
  private String listingDescription;
  private long id;
  private long edition;
  private String version;
  private AlphStd alphabet;
  private String description;
  private String fileSeq;
  private String fileBg;
  private String fileSeqIndex;
  private long sequenceCount;
  private long totalLen;
  private long minLen;
  private long maxLen;
  private double avgLen;
  private double stdDLen;
  private int priorCount;

  public SequenceDB(
    String listingName, 
    String listingDescription,
    long id, 
    AlphStd alphabet, 
    long edition, 
    String version,
    String description, 
    String fileSeq, 
    String fileBg, 
    String fileSeqIndex, 
    long sequenceCount,
    long totalLen, 
    long minLen, 
    long maxLen, 
    double avgLen, 
    double stdDLen, 
    int priorCount
  ) {
    this.listingName = listingName;
    this.listingDescription = listingDescription;
    this.id = id;
    this.alphabet = alphabet;
    this.edition = edition;
    this.version = version;
    this.description = description;
    this.fileSeq = fileSeq;
    this.fileBg = fileBg;
    this.fileSeqIndex = fileSeqIndex;
    this.sequenceCount = sequenceCount;
    this.totalLen = totalLen;
    this.minLen = minLen;
    this.maxLen = maxLen;
    this.avgLen = avgLen;
    this.stdDLen = stdDLen;
    this.priorCount = priorCount;
  }

  public String getListingName() {
    return listingName;
  }

  public String getListingDescription() {
    return listingDescription;
  }

  public long getId() {
    return id;
  }

  public long getEdition() {
    return edition;
  }

  public String getVersion() {
    return version;
  }

  public String getDescription() {
    return description;
  }

  public String getSequenceName() {
    return fileSeq;
  }

  public String getBackgroundName() {
    return fileBg;
  }

  public String getSeqIndexName() {
    return fileSeqIndex;
  }

  @Override
  public AlphStd guessAlphabet() {
    return alphabet;
  }

  @Override
  public boolean checkAlphabet(Alph alph) {
    return alphabet.getAlph().equals(alph);
  }

  @Override
  public long getSequenceCount() {
    return sequenceCount;
  }

  @Override
  public long getTotalLength() {
    return totalLen;
  }

  @Override
  public long getMinLength() {
    return minLen;
  }

  @Override
  public long getMaxLength() {
    return maxLen;
  }

  @Override
  public double getAverageLength() {
    return avgLen;
  }

  @Override
  public double getStandardDeviationLength() {
    return stdDLen;
  }

  public int getPriorCount() {
    return priorCount;
  }

  @Override
  public void outputJson(JsonWr out) throws IOException {
    out.startObject();
    out.property("source", "db");
    out.property("db_name", listingName);
    out.property("db_description", listingDescription);
    out.property("alphabet", guessAlphabet().name());
    out.property("count", getSequenceCount());
    out.property("min", getMinLength());
    out.property("max", getMaxLength());
    out.property("avg", getAverageLength());
    out.property("total", getTotalLength());
    out.endObject();
  }
}
